/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.nhm.eui;

import ibm.nways.analysis.dpCommon.DataPoint;
import ibm.nways.analysis.dpCommon.EventFilter;
import ibm.nways.analysis.dpCommon.NotifyObject;
import ibm.nways.analysis.dpCommon.PerformanceEvent;
import ibm.nways.analysis.dpCommon.PollingObjectDefinition;
import ibm.nways.analysis.dpManager.AppletNotifyInterface;
import ibm.nways.analysis.dpManager.DpResourceManagerClass;
import ibm.nways.analysis.dpManager.DpmClientApplet;
import ibm.nways.nhm.eui.NhmChart;
import ibm.nways.nhm.eui.NhmResourceManager;
import ibm.nways.nhm.eui.NhmViewPage;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import jclass.bwt.JCItemEvent;
import jclass.bwt.JCItemListener;
import jclass.bwt.JCMultiColumnList;
import jclass.chart.ChartDataView;
import jclass.chart.ChartDataViewSeries;
import jclass.chart.Chartable;
import jclass.chart.EventTrigger;
import jclass.chart.JCAxis;
import jclass.chart.JCChart;
import jclass.chart.JCChartArea;
import jclass.chart.JCChartLabel;
import jclass.chart.JCChartStyle;
import jclass.chart.JCChartTimeUtil;
import jclass.chart.JCDataIndex;
import jclass.chart.JCPickEvent;
import jclass.chart.JCPickListener;

public class NhmEventViewImpl
extends NhmViewPage
implements AppletNotifyInterface,
ComponentListener,
ActionListener,
JCItemListener,
Chartable,
JCPickListener {
    Panel topPanel;
    boolean topPanelAdded = false;
    Panel panel;
    JCMultiColumnList list;
    Button details;
    Button clear;
    Button clearAll;
    Button clearRearmed;
    Button refresh;
    int numSelected;
    DpResourceManagerClass resource;
    private DpmClientApplet server;
    boolean registeredForEvents = false;
    Date eventRegistrationDate;
    Vector events;
    Vector activeEvents;
    Vector detailDates;
    Vector detailArmValues;
    Vector detailRearmValues;
    Date detailTimeBase;
    Hashtable eventDirectory;
    NhmChart chart;
    String armCondition;
    String rearmCondition;
    JCChartLabel pickChartLabel;
    private ResourceBundle nhmRes = ResourceBundle.getBundle("ibm.nways.nhm.eui.NhmResources");

    public NhmEventViewImpl(DpmClientApplet dpmClientApplet, NhmResourceManager nhmResourceManager) {
        this.server = dpmClientApplet;
        this.addComponentListener(this);
        try {
            UnicastRemoteObject.exportObject(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.resource = new DpResourceManagerClass(nhmResourceManager.dpGetHostname(), nhmResourceManager.dpGetDeviceType(), nhmResourceManager.dpGetResourceType(), nhmResourceManager.dpGetResourceInstance());
        this.topPanel = new Panel(new BorderLayout());
        this.panel = new Panel(new BorderLayout());
        this.panel.setForeground(Color.black);
        this.panel.setBackground(Color.lightGray);
        Panel panel = new Panel();
        panel.setForeground(Color.black);
        this.details = new Button(this.nhmRes.getString("s_Details"));
        this.details.setBackground(Color.lightGray);
        this.clear = new Button(this.nhmRes.getString("s_Clear"));
        this.clear.setBackground(Color.lightGray);
        this.clearRearmed = new Button(this.nhmRes.getString("s_ClearRearmed"));
        this.clearRearmed.setBackground(Color.lightGray);
        this.clearAll = new Button(this.nhmRes.getString("s_ClearAll"));
        this.clearAll.setBackground(Color.lightGray);
        this.refresh = new Button(this.nhmRes.getString("s_Refresh"));
        this.refresh.setBackground(Color.lightGray);
        this.details.addActionListener(this);
        this.clear.addActionListener(this);
        this.clear.setEnabled(false);
        this.clearRearmed.addActionListener(this);
        this.clearRearmed.setEnabled(false);
        this.clearAll.addActionListener(this);
        this.clearAll.setEnabled(false);
        this.refresh.addActionListener(this);
        this.refresh.setEnabled(false);
        panel.add(this.details);
        panel.add(this.clear);
        panel.add(this.clearAll);
        panel.add(this.clearRearmed);
        panel.add(this.refresh);
        this.topPanel.add("Center", this.panel);
        this.topPanel.add("South", panel);
    }

    public JCMultiColumnList createList() {
        this.list = new JCMultiColumnList(10, true);
        this.list.addItemListener(this);
        String[] stringArray = new String[]{this.nhmRes.getString("s_Status"), this.nhmRes.getString("s_Time"), this.nhmRes.getString("s_PollingObject"), this.nhmRes.getString("s_Value")};
        this.list.setColumnButtons(stringArray);
        return this.list;
    }

    public void componentHidden(ComponentEvent componentEvent) {
        this.unregisterForEvents();
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.registerForEvents();
        this.refresh();
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.clear) {
            Object[] objectArray = this.list.getSelectedObjects();
            Vector<PerformanceEvent> vector = new Vector<PerformanceEvent>();
            int n = 0;
            while (n < objectArray.length) {
                Vector vector2 = (Vector)objectArray[n];
                PerformanceEvent performanceEvent = (PerformanceEvent)this.eventDirectory.remove(vector2);
                if (performanceEvent != null) {
                    vector.addElement(performanceEvent);
                }
                ++n;
            }
            this.clearEvents(vector);
            this.clear.setEnabled(false);
            this.clearAll.setEnabled(false);
            if (this.activeEvents.size() == this.events.size()) {
                this.clearRearmed.setEnabled(false);
            }
            this.refresh();
            return;
        }
        if (actionEvent.getSource() == this.clearRearmed) {
            this.clearRearmedEvents();
            this.clear.setEnabled(false);
            this.clearRearmed.setEnabled(false);
            if (this.events.size() == 0) {
                this.clearAll.setEnabled(false);
            }
            this.refresh();
            return;
        }
        if (actionEvent.getSource() == this.clearAll) {
            this.clearAllEvents();
            this.clear.setEnabled(false);
            this.clearAll.setEnabled(false);
            this.clearRearmed.setEnabled(false);
            this.refresh();
            return;
        }
        if (actionEvent.getSource() == this.details) {
            PerformanceEvent performanceEvent = null;
            Object[] objectArray = this.list.getSelectedObjects();
            if (objectArray != null) {
                Vector vector = (Vector)objectArray[0];
                performanceEvent = (PerformanceEvent)this.eventDirectory.get(vector);
            }
            this.showDetails(performanceEvent);
            return;
        }
        if (actionEvent.getSource() == this.refresh) {
            this.refresh();
        }
    }

    public synchronized PerformanceEvent getActive(String string) {
        PerformanceEvent performanceEvent = null;
        Enumeration enumeration = this.activeEvents.elements();
        while (performanceEvent == null && enumeration.hasMoreElements()) {
            PerformanceEvent performanceEvent2 = (PerformanceEvent)enumeration.nextElement();
            if (!string.equals(performanceEvent2.getName().getTranslation())) continue;
            performanceEvent = performanceEvent2;
        }
        return performanceEvent;
    }

    public synchronized void showDetails(PerformanceEvent performanceEvent) {
        Serializable serializable;
        Object object;
        double d = 0.0;
        long l = 0L;
        PollingObjectDefinition pollingObjectDefinition = null;
        this.armCondition = null;
        this.rearmCondition = null;
        if (performanceEvent != null) {
            try {
                pollingObjectDefinition = this.server.getPollingDefinition(performanceEvent.getIdentifier());
                object = pollingObjectDefinition.getNotifyObject();
                this.armCondition = String.valueOf(((NotifyObject)object).getArmOp()) + " " + String.valueOf(((NotifyObject)object).getArmValue());
                this.rearmCondition = String.valueOf(((NotifyObject)object).getRearmOp()) + " " + String.valueOf(((NotifyObject)object).getRearmValue());
            }
            catch (Exception exception) {
                pollingObjectDefinition = null;
                exception.printStackTrace();
            }
        }
        this.detailDates = new Vector();
        this.detailArmValues = new Vector();
        this.detailRearmValues = new Vector();
        this.detailTimeBase = null;
        object = this.events.elements();
        double d2 = 0.0;
        double d3 = 0.0;
        long l2 = 0L;
        boolean bl = false;
        while (object.hasMoreElements()) {
            serializable = (PerformanceEvent)object.nextElement();
            if (performanceEvent != null && !((PerformanceEvent)serializable).getName().getTranslation().equals(performanceEvent.getName().getTranslation())) continue;
            bl = true;
            if (this.detailTimeBase == null) {
                l2 = ((PerformanceEvent)serializable).getEventTime();
                this.detailTimeBase = new Date(((PerformanceEvent)serializable).getEventTime());
            }
            switch (((PerformanceEvent)serializable).getCause()) {
                case 1: {
                    if (((PerformanceEvent)serializable).getEventTime() != l2) {
                        l = l2 - this.detailTimeBase.getTime();
                        d = l / 1000L;
                        this.detailDates.addElement(new Double(d));
                        this.detailArmValues.addElement(new Double(d2));
                        this.detailRearmValues.addElement(new Double(d3));
                        l2 = ((PerformanceEvent)serializable).getEventTime();
                    }
                    d2 += 1.0;
                    break;
                }
                case 2: {
                    if (((PerformanceEvent)serializable).getEventTime() != l2) {
                        l = l2 - this.detailTimeBase.getTime();
                        d = l / 1000L;
                        this.detailDates.addElement(new Double(d));
                        this.detailArmValues.addElement(new Double(d2));
                        this.detailRearmValues.addElement(new Double(d3));
                        l2 = ((PerformanceEvent)serializable).getEventTime();
                    }
                    d2 -= 1.0;
                    d3 += 1.0;
                    break;
                }
            }
        }
        if (bl) {
            l = l2 - this.detailTimeBase.getTime();
            d = l / 1000L;
            this.detailDates.addElement(new Double(d));
            this.detailArmValues.addElement(new Double(d2));
            this.detailRearmValues.addElement(new Double(d3));
        }
        if (this.detailDates.size() > 0) {
            if (this.chart != null) {
                this.panel.remove(this.chart);
            }
            this.chart = new NhmChart();
            this.chart.getHeader().setIsShowing(true);
            if (performanceEvent != null) {
                this.chart.getHeader().getLabel().setText(performanceEvent.getName().getTranslation());
            } else {
                this.chart.getHeader().getLabel().setText(this.getName());
            }
            this.chart.getLegend().setIsShowing(true);
            this.chart.getLegend().setAnchor(32);
            serializable = this.chart.getDataView(0);
            ((ChartDataView)serializable).setDataSource(this);
            ((ChartDataView)serializable).setChartType(10);
            ChartDataViewSeries chartDataViewSeries = ((ChartDataView)serializable).getSeries(0);
            JCChartStyle jCChartStyle = new JCChartStyle();
            jCChartStyle.setFillColor(Color.green);
            chartDataViewSeries.setStyle(jCChartStyle);
            ChartDataViewSeries chartDataViewSeries2 = ((ChartDataView)serializable).getSeries(1);
            JCChartStyle jCChartStyle2 = new JCChartStyle();
            jCChartStyle2.setFillColor(Color.red);
            chartDataViewSeries2.setStyle(jCChartStyle2);
            JCAxis jCAxis = ((ChartDataView)serializable).getXAxis();
            jCAxis.setTimeUnit(1000L);
            jCAxis.setTimeBase(this.detailTimeBase);
            jCAxis.setAnnotationMethod(2);
            jCAxis.setTimeFormat("%c");
            this.chart.setTrigger(0, new EventTrigger(0, 4));
            this.chart.setTrigger(1, new EventTrigger(1, 1));
            this.chart.setTrigger(2, new EventTrigger(8, 0));
            this.chart.setTrigger(3, new EventTrigger(2, 2));
            this.chart.getChartArea().setFastAction(true);
            this.chart.addPickListener(this);
            this.panel.add("South", this.chart);
            this.invalidate();
            this.validate();
        }
    }

    public void itemStateChanged(JCItemEvent jCItemEvent) {
        Object[] objectArray = this.list.getSelectedObjects();
        if (objectArray == null) {
            this.clear.setEnabled(false);
            return;
        }
        if (objectArray.length == 1) {
            this.details.setEnabled(true);
        } else {
            this.details.setEnabled(false);
        }
        this.clear.setEnabled(true);
    }

    public void registerForEvents() {
        if (!this.registeredForEvents) {
            if (this.eventRegistrationDate == null) {
                this.eventRegistrationDate = new Date(0L);
            }
            EventFilter eventFilter = new EventFilter(new Integer(67), this.resource, this.eventRegistrationDate.getTime(), 1);
            try {
                this.server.registerForEvents(this, eventFilter);
                this.registeredForEvents = true;
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
    }

    public synchronized void clearEvents(Vector vector) {
        try {
            this.server.clearEvents(vector);
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                PerformanceEvent performanceEvent = (PerformanceEvent)enumeration.nextElement();
                this.events.removeElement(performanceEvent);
                if (!this.activeEvents.contains(performanceEvent)) continue;
                this.activeEvents.removeElement(performanceEvent);
            }
            return;
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return;
        }
    }

    public synchronized void clearAllEvents() {
        try {
            this.server.clearEvents(this.events);
            this.events.removeAllElements();
            this.activeEvents.removeAllElements();
            return;
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return;
        }
    }

    public synchronized void clearRearmedEvents() {
        Vector<PerformanceEvent> vector = new Vector<PerformanceEvent>();
        Enumeration enumeration = this.events.elements();
        while (enumeration.hasMoreElements()) {
            PerformanceEvent performanceEvent = (PerformanceEvent)enumeration.nextElement();
            if (this.activeEvents.contains(performanceEvent)) continue;
            vector.addElement(performanceEvent);
        }
        if (vector.size() > 0) {
            this.clearEvents(vector);
        }
    }

    public void unregisterForEvents() {
        this.unregisterForEvents(this.server);
    }

    public void unregisterForEvents(DpmClientApplet dpmClientApplet) {
        if (this.registeredForEvents) {
            try {
                dpmClientApplet.unregisterForEvents(this);
                this.eventRegistrationDate = new Date();
                this.registeredForEvents = false;
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
    }

    public String getTitle() {
        return this.nhmRes.getString("s_StatusEvents");
    }

    public void updateComponent(Component component) {
        component.repaint();
    }

    public synchronized void updateView() {
        this.refresh();
    }

    public synchronized void recreateView() {
        if (!this.topPanelAdded) {
            this.addComponent(this.topPanel);
            this.topPanelAdded = true;
        }
        if (this.registeredForEvents) {
            this.unregisterForEvents();
            this.eventRegistrationDate = null;
            this.registeredForEvents = false;
        }
        this.getEvents();
        this.registerForEvents();
        this.refresh();
    }

    private synchronized void refresh() {
        if (this.list != null) {
            this.panel.remove(this.list);
        }
        if (this.chart != null) {
            this.panel.remove(this.chart);
        }
        this.list = this.createList();
        this.eventDirectory = new Hashtable();
        int n = this.events.size();
        if (n > 0) {
            this.clearAll.setEnabled(true);
            this.details.setEnabled(true);
        } else {
            this.clearAll.setEnabled(false);
            this.details.setEnabled(false);
        }
        this.clear.setEnabled(false);
        int n2 = 0;
        while (n2 < n) {
            PerformanceEvent performanceEvent = (PerformanceEvent)this.events.elementAt(n - 1 - n2);
            Vector<String> vector = new Vector<String>();
            vector.addElement(PerformanceEvent.toString(performanceEvent.getCause()));
            vector.addElement(JCChartTimeUtil.timeLabel("%c", new Date(performanceEvent.getEventTime())));
            vector.addElement(performanceEvent.getName().getTranslation());
            DataPoint dataPoint = performanceEvent.getDataPoint();
            if (dataPoint != null) {
                vector.addElement(String.valueOf(dataPoint.getValue()));
            } else {
                vector.addElement(new String());
            }
            this.list.addItem(vector);
            this.eventDirectory.put(vector, performanceEvent);
            ++n2;
        }
        this.panel.add("Center", this.list);
        this.showDetails(null);
        if (this.refresh.isEnabled()) {
            this.refresh.setEnabled(false);
        }
        this.invalidate();
        this.validate();
    }

    public synchronized void processEvents(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            PerformanceEvent performanceEvent;
            PerformanceEvent performanceEvent2 = (PerformanceEvent)enumeration.nextElement();
            if (performanceEvent2.getCause() == 1) {
                performanceEvent = this.getActive(performanceEvent2.getName().getTranslation());
                if (performanceEvent != null) {
                    this.activeEvents.removeElement(performanceEvent);
                }
                this.activeEvents.addElement(performanceEvent2);
            } else if (performanceEvent2.getCause() == 2 && (performanceEvent = this.getActive(performanceEvent2.getName().getTranslation())) != null) {
                this.activeEvents.removeElement(performanceEvent);
            }
            this.events.addElement(performanceEvent2);
        }
        if (this.activeEvents.size() != this.events.size()) {
            this.clearRearmed.setEnabled(true);
        }
    }

    public synchronized void updateEvent(Vector vector) {
        this.processEvents(vector);
        if (!this.refresh.isEnabled()) {
            this.refresh.setEnabled(true);
        }
    }

    public synchronized void getEvents() {
        this.events = new Vector();
        this.activeEvents = new Vector();
        try {
            Vector vector = this.server.getEvents(new EventFilter(new Integer(67), this.resource, 0L, 1));
            this.eventRegistrationDate = new Date();
            if (vector != null) {
                this.processEvents(vector);
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int getDataInterpretation() {
        return 0;
    }

    public Object getDataItem(int n, int n2) {
        Double d = null;
        switch (n) {
            case 0: {
                d = (Double)this.detailDates.elementAt(n2);
                break;
            }
            case 1: {
                d = (Double)this.detailRearmValues.elementAt(n2);
                break;
            }
            case 2: {
                d = (Double)this.detailArmValues.elementAt(n2);
                break;
            }
        }
        return d;
    }

    public synchronized Vector getRow(int n) {
        Vector vector = null;
        switch (n) {
            case 0: {
                vector = this.detailDates;
                break;
            }
            case 1: {
                vector = this.detailRearmValues;
                break;
            }
            case 2: {
                vector = this.detailArmValues;
                break;
            }
        }
        return vector;
    }

    public int getNumRows() {
        return 3;
    }

    public String[] getPointLabels() {
        String[] stringArray = null;
        return stringArray;
    }

    public String getSeriesName(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = this.nhmRes.getString("s_Rearmed");
                if (this.rearmCondition == null) break;
                string.concat(" (" + this.rearmCondition + ")");
                break;
            }
            case 1: {
                string = this.nhmRes.getString("s_Armed");
                if (this.armCondition == null) break;
                string.concat(" (" + this.armCondition + ")");
                break;
            }
        }
        return string;
    }

    public String getSeriesLabel(int n) {
        return this.getSeriesName(n);
    }

    public String getName() {
        return this.nhmRes.getString("s_ActiveStatusEvents");
    }

    public void pick(JCPickEvent jCPickEvent) {
        JCChart jCChart = null;
        boolean bl = false;
        JCDataIndex jCDataIndex = jCPickEvent.getPickResult();
        if (jCDataIndex != null) {
            Object object = jCDataIndex.getObject();
            int n = jCDataIndex.getDistance();
            ChartDataView chartDataView = jCDataIndex.getDataView();
            jCDataIndex.getSeries();
            jCDataIndex.getSeriesIndex();
            jCDataIndex.getPoint();
            Component component = (Component)object;
            Container container = component.getParent();
            if (container instanceof JCChart) {
                jCChart = (JCChart)container;
            }
            if (object instanceof JCChartArea) {
                JCChartArea cfr_ignored_0 = (JCChartArea)object;
                if (n > 5) {
                    jCChart.reset();
                    bl = true;
                }
            }
            if (chartDataView != null && bl) {
                chartDataView.setChanged(true);
            }
        }
    }
}

